import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/route/route.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/core/utils/my_images.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/core/utils/style.dart';
import 'package:viserpay_agent/data/controller/add_money/add_money_method_controller.dart';
import 'package:viserpay_agent/data/repo/add_money/add_money_method_repo.dart';
import 'package:viserpay_agent/data/services/api_service.dart';
import 'package:viserpay_agent/view/components/app-bar/action_button_icon_widget.dart';
import 'package:viserpay_agent/view/components/app-bar/custom_appbar.dart';
import 'package:viserpay_agent/view/components/bottom-sheet/custom_bottom_sheet.dart';
import 'package:viserpay_agent/view/components/buttons/gradient_rounded_button.dart';
import 'package:viserpay_agent/view/components/custom_loader/custom_loader.dart';
import 'package:viserpay_agent/view/components/text-form-field/custom_amount_text_field.dart';
import 'package:viserpay_agent/view/components/text/label_text.dart';
import 'package:viserpay_agent/view/screens/add-money/add_money/widget/add_money_info_widget.dart';
import 'package:viserpay_agent/view/screens/add-money/add_money/widget/money_gateway_bottom_sheet.dart';
import 'package:viserpay_agent/view/screens/transaction/widget/filter_row_widget.dart';

class AddMoneyScreen extends StatefulWidget {
  const AddMoneyScreen({super.key});

  @override
  State<AddMoneyScreen> createState() => _AddMoneyScreenState();
}

class _AddMoneyScreenState extends State<AddMoneyScreen> {
  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(AddMoneyMethodRepo(apiClient: Get.find()));
    final controller = Get.put(AddMoneyMethodController(addMoneyMethodRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.loadData();
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<AddMoneyMethodController>(
        builder: (controller) => Scaffold(
              backgroundColor: MyColor.getScreenBgColor(isWhite: true),
              appBar: CustomAppBar(
                title: MyStrings.addMoney,
                action: [
                  ActionButtonIconWidget(
                    pressed: () => Get.toNamed(RouteHelper.addMoneyHistoryScreen),
                    isImage: true,
                    imageSrc: MyImages.moneyHistory,
                    backgroundColor: MyColor.primaryColor.withOpacity(0.1),
                    iconColor: MyColor.primaryColor,
                  )
                ],
              ),
              body: controller.isLoading
                  ? const CustomLoader()
                  : SingleChildScrollView(
                      padding: Dimensions.screenPaddingHV,
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          const SizedBox(height: Dimensions.space20),
                          const LabelText(text: MyStrings.selectGateway),
                          const SizedBox(height: Dimensions.textToTextSpace),
                          FilterRowWidget(
                            borderColor: controller.selectedGateway?.id.toString() == "-1" ? MyColor.textFieldDisableBorderColor : MyColor.textFieldEnableBorderColor,
                            text: "${controller.selectedGateway?.id.toString() == "-1" ? MyStrings.selectGateway : controller.selectedGateway?.name}",
                            press: () => CustomBottomSheet(child: const AddMoneyGatewayBottomSheet()).customBottomSheet(context),
                          ),
                          const SizedBox(height: Dimensions.space20),
                          CustomAmountTextField(
                            labelText: MyStrings.amount.tr,
                            hintText: MyStrings.amountHint.tr,
                            currency: controller.currency,
                            controller: controller.amountController,
                            onChanged: (value) {
                              if (value.toString().isEmpty) {
                                controller.changeInfoWidgetValue(0);
                              } else {
                                double amount = double.tryParse(value.toString()) ?? 0;
                                controller.changeInfoWidgetValue(amount);
                              }
                            },
                          ),
                          const SizedBox(height: Dimensions.space5),
                          controller.selectedGateway?.name == MyStrings.selectGateway
                              ? const SizedBox.shrink()
                              : Text(
                                  "${MyStrings.depositLimit.tr}: ${controller.depositMinLimit} - ${controller.depositMaxLimit} ${controller.currency}",
                                  style: regularExtraSmall.copyWith(color: MyColor.getPrimaryColor(), fontWeight: FontWeight.w400),
                                ),
                          const SizedBox(height: Dimensions.space20),
                          controller.mainAmount > 0 ? const AddcashInfoWidget() : const SizedBox(),
                          const SizedBox(height: Dimensions.space30),
                          GradientRoundedButton(
                            showLoadingIcon: controller.submitLoading,
                            press: () {
                              controller.submitData();
                            },
                            text: MyStrings.proceed.tr,
                          )
                        ],
                      ),
                    ),
            ));
  }
}
